//+------------------------------------------------------------------+
//|                                              Keltner Channel.mq4 |
//|                                                  Coded by Gilani |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 Red
#property indicator_color2 Blue
#property indicator_color3 Red
//---- input parameters
extern int ChannelPeriod = 10;
//----
double upper[], middle[], lower[];
//+------------------------------------------------------------------+  
//----+   GetKeltner 
#include <GetKeltner.mqh>  
//+------------------------------------------------------------------+ 
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   SetIndexBuffer(0, upper);
   SetIndexStyle(0, DRAW_LINE);
   SetIndexShift(0, 0);
   SetIndexDrawBegin(0, 0);
//----
   SetIndexBuffer(1, middle);
   SetIndexStyle(1, DRAW_LINE);
   SetIndexShift(1, 0);
   SetIndexDrawBegin(1, 0);
//----
   SetIndexBuffer(2, lower);
   SetIndexStyle(2, DRAW_LINE);
   SetIndexShift(2, 0);
   SetIndexDrawBegin(2, 0);
//---- name for DataWindow label
   SetIndexLabel(0, "KChanUp("  + ChannelPeriod + ")");    
   SetIndexLabel(1, "KChanMid(" + ChannelPeriod + ")"); 
   SetIndexLabel(2, "KChanLow(" + ChannelPeriod + ")"); 
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start() 
  {
double Keltner;   
   //----+        
int MaxBar,bar,limit,counted_bars=IndicatorCounted(); 
//----    
if (counted_bars<0)return(-1);
//----       
if (counted_bars>0) counted_bars--;
//----     ,         
MaxBar=Bars-1-ChannelPeriod;
limit=Bars-counted_bars-1; 
//----
   for(bar = 0; bar < limit; bar++) 
     {
      middle[bar] = iMA(NULL, 0, ChannelPeriod, 0, MODE_SMA, PRICE_TYPICAL, bar);
      Keltner = GetKeltner(NULL, 0, ChannelPeriod, bar);
      upper[bar] = middle[bar] + Keltner;
      lower[bar] = middle[bar] - Keltner;
     }
   return(0);
  }
//+--------------------------------------------------------+





